#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25454);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1558");

 name["english"] = "RHSA-2007-0385: fetchmail";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated fetchmail package that fixes a security bug is now available for
  Red Hat Enterprise Linux 2.1, 3, 4 and 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Fetchmail is a remote mail retrieval and forwarding utility intended
  for use over on-demand TCP/IP links, like SLIP or PPP connections.

  A flaw was found in the way fetchmail processed certain APOP authentication
  requests. By sending certain responses when fetchmail attempted to
  authenticate against an APOP server, a remote attacker could potentially
  acquire certain portions of a user\'s authentication credentials.
  (CVE-2007-1558)

  All users of fetchmail should upgrade to this updated package, which
  contains a backported patch to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0385.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the fetchmail packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"fetchmail-6.3.6-1.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"fetchmail-5.9.0-21.7.3.el2.1.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"fetchmailconf-5.9.0-21.7.3.el2.1.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"fetchmail-6.2.0-3.el3.4", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"fetchmail-6.2.5-6.0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"fetchmail-5.9.0-21.7.3.el2.1.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"fetchmailconf-5.9.0-21.7.3.el2.1.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"fetchmail-6.2.5-6.0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"fetchmail-5.9.0-21.7.3.el2.1.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"fetchmailconf-5.9.0-21.7.3.el2.1.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"fetchmail-6.2.5-6.0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"fetchmail-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
}
if ( rpm_exists(rpm:"fetchmail-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
}
if ( rpm_exists(rpm:"fetchmail-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
}
if ( rpm_exists(rpm:"fetchmail-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
}
if ( rpm_exists(rpm:"fetchmail-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
}
if ( rpm_exists(rpm:"fetchmail-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
}
if ( rpm_exists(rpm:"fetchmail-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
}
if ( rpm_exists(rpm:"fetchmail-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0385", value:TRUE);
