#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25363);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1995");

 name["english"] = "RHSA-2007-0389: quagga";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated quagga package that fixes a security bug is now available for
  Red Hat Enterprise Linux 3, 4 and 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Quagga is a TCP/IP based routing software suite.

  An out of bounds memory read flaw was discovered in Quagga\'s bgpd. A
  configured peer of bgpd could cause Quagga to crash, leading to a denial of
  service (CVE-2007-1995).

  All users of Quagga should upgrade to this updated package, which
  contains a backported patch to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0389.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the quagga packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"quagga-0.98.6-2.1.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"quagga-contrib-0.98.6-2.1.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"quagga-devel-0.98.6-2.1.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"quagga-0.96.2-12.3E", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"quagga-0.98.3-2.4.0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"quagga-contrib-0.98.3-2.4.0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"quagga-devel-0.98.3-2.4.0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"quagga-contrib-0.98.6-2.1.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"quagga-0.96.2-12.3E", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"quagga-0.98.3-2.4.0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"quagga-contrib-0.98.3-2.4.0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"quagga-devel-0.98.3-2.4.0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"quagga-0.98.3-2.4.0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"quagga-contrib-0.98.3-2.4.0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"quagga-devel-0.98.3-2.4.0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"quagga-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1995", value:TRUE);
}
if ( rpm_exists(rpm:"quagga-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-1995", value:TRUE);
}
if ( rpm_exists(rpm:"quagga-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-1995", value:TRUE);
}
if ( rpm_exists(rpm:"quagga-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1995", value:TRUE);
}
if ( rpm_exists(rpm:"quagga-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-1995", value:TRUE);
}
if ( rpm_exists(rpm:"quagga-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-1995", value:TRUE);
}
if ( rpm_exists(rpm:"quagga-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-1995", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0389", value:TRUE);
