#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25476);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-2754");

 name["english"] = "RHSA-2007-0403: freetype";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated freetype packages that fix a security flaw are now available for Red
  Hat Enterprise Linux 2.1, 3, 4, and 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  FreeType is a free, high-quality, portable font engine.

  An integer overflow flaw was found in the way the FreeType font engine
  processed TTF font files. If a user loaded a carefully crafted font file
  with a program linked against FreeType, it could cause the application to
  crash or execute arbitrary code. While it is uncommon for a user to
  explicitly load a font file, there are several application file formats
  which contain embedded fonts that are parsed by FreeType. (CVE-2007-2754)

  Users of FreeType should upgrade to these updated packages, which contain
  a backported patch to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0403.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the freetype packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"freetype-2.2.1-19.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-demos-2.2.1-19.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-devel-2.2.1-19.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-2.0.3-10.el21", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-devel-2.0.3-10.el21", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-utils-2.0.3-10.el21", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-2.1.4-7.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-devel-2.1.4-7.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-2.1.9-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-demos-2.1.9-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-devel-2.1.9-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-utils-2.1.9-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-2.2.1-19.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-2.0.3-10.el21", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-devel-2.0.3-10.el21", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-utils-2.0.3-10.el21", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-2.1.9-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-demos-2.1.9-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-devel-2.1.9-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-utils-2.1.9-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-2.0.3-10.el21", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-devel-2.0.3-10.el21", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-utils-2.0.3-10.el21", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-2.1.9-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-demos-2.1.9-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-devel-2.1.9-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"freetype-utils-2.1.9-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"freetype-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-2754", value:TRUE);
}
if ( rpm_exists(rpm:"freetype-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-2754", value:TRUE);
}
if ( rpm_exists(rpm:"freetype-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-2754", value:TRUE);
}
if ( rpm_exists(rpm:"freetype-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2754", value:TRUE);
}
if ( rpm_exists(rpm:"freetype-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-2754", value:TRUE);
}
if ( rpm_exists(rpm:"freetype-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-2754", value:TRUE);
}
if ( rpm_exists(rpm:"freetype-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2754", value:TRUE);
}
if ( rpm_exists(rpm:"freetype-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-2754", value:TRUE);
}
if ( rpm_exists(rpm:"freetype-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2754", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0403", value:TRUE);
