#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25478);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-1174");

 name["english"] = "RHSA-2007-0431: shadow";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated shadow-utils package that fixes a security issue and several
  bugs is now available.

  This update has been rated as having low security impact by the Red Hat
  Security Response Team.

  The shadow-utils package includes the necessary programs for converting
  UNIX password files to the shadow password format, as well as programs
  for managing user and group accounts.

  A flaw was found in the useradd tool in shadow-utils. A new user\'s
  mailbox, when created, could have random permissions for a short period.
  This could allow a local attacker to read or modify the mailbox.
  (CVE-2006-1174)

  This update also fixes the following bugs:

  * shadow-utils debuginfo package was empty.

  * chage.1 and chage -l gave incorrect information about sp_inact.

  All users of shadow-utils are advised to upgrade to this updated
  package, which contains backported patches to resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0431.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the shadow packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"shadow-utils-4.0.3-29.RHEL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"shadow-utils-4.0.3-29.RHEL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"shadow-utils-4.0.3-29.RHEL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"shadow-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-1174", value:TRUE);
}
if ( rpm_exists(rpm:"shadow-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-1174", value:TRUE);
}
if ( rpm_exists(rpm:"shadow-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-1174", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0431", value:TRUE);
