#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25481);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4146");

 name["english"] = "RHSA-2007-0469: gdb";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated gdb package that fixes a security issue and various bugs is now
  available.

  This update has been rated as having low security impact by the Red Hat
  Security Response Team.

  GDB, the GNU debugger, allows debugging of programs written in C, C++, and
  other languages by executing them in a controlled fashion and then printing
  their data.

  Various buffer overflows and underflows were found in the DWARF expression
  computation stack in GDB. If an attacker could trick a user into loading
  an executable containing malicious debugging information into GDB, they may
  be able to execute arbitrary code with the privileges of the user.
  (CVE-2006-4146)

  This updated package also addresses the following issues:

  * Support on 64-bit hosts shared libraries debuginfo larger than 2GB.

  * Fix a race occasionally leaving the detached processes stopped.

  * Fix segmentation fault on the source display by ^X 1.

  * Fix a crash on an opaque type dereference.

  All users of gdb should upgrade to this updated package, which contains
  backported patches to resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0469.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gdb packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gdb-6.3.0.0-1.138.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gdb-6.3.0.0-1.138.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gdb-6.3.0.0-1.138.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"gdb-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-4146", value:TRUE);
}
if ( rpm_exists(rpm:"gdb-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-4146", value:TRUE);
}
if ( rpm_exists(rpm:"gdb-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-4146", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0469", value:TRUE);
