#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25539);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1349");

 name["english"] = "RHSA-2007-0486: mod_perl";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated mod_perl packages that fix a security issue are now available for
  Red
  Hat Enterprise Linux 2.1.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Mod_perl incorporates a Perl interpreter into the Apache web server,
  so that the Apache HTTP server can directly execute Perl code.

  The Apache::PerlRun module was found to not properly escape PATH_INFO
  before being used in a regular expression. If a server is configured to
  use Apache::PerlRun, an attacker could request a carefully crafted URI
  causing resource consumption, which could lead to a denial of service
  (CVE-2007-1349).

  Users of mod_perl should update to these erratum packages which contain a
  backported fix to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0486.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mod_perl packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"mod_perl-1.26-8.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mod_perl-1.26-8.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"mod_perl-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-1349", value:TRUE);
}
if ( rpm_exists(rpm:"mod_perl-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-1349", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0486", value:TRUE);
