#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25521);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-2873");

 name["english"] = "RHSA-2007-0492: spamassassin";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated spamassassin packages that fix a security issue are now available
  for Red Hat Enterprise Linux 4 and 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  SpamAssassin provides a way to reduce unsolicited commercial email (spam)
  from incoming email.

  Martin Krafft discovered a symlink issue in SpamAssassin that affects
  certain non-default configurations. A local user could use this flaw to
  create or overwrite files writable by the spamd process (CVE-2007-2873).

  Users of SpamAssassin should upgrade to these updated packages which
  contain a backported patch to correct this issue.

  Note: This issue did not affect the version of SpamAssassin shipped with
  Red Hat Enterprise Linux 3.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0492.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the spamassassin packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"spamassassin-3.1.9-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"spamassassin-3.1.9-1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"spamassassin-3.1.9-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"spamassassin-3.1.9-1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"spamassassin-3.1.9-1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"spamassassin-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-2873", value:TRUE);
}
if ( rpm_exists(rpm:"spamassassin-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2873", value:TRUE);
}
if ( rpm_exists(rpm:"spamassassin-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-2873", value:TRUE);
}
if ( rpm_exists(rpm:"spamassassin-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2873", value:TRUE);
}
if ( rpm_exists(rpm:"spamassassin-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2873", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0492", value:TRUE);
