#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25522);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-2022");

 name["english"] = "RHSA-2007-0494: kdebase";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated kdebase packages that resolve an interaction security issue with
  Adobe Flash Player are now available.

  This update has been rated as having important security impact by the Red Hat
  Security Response Team.

  The kdebase packages provide the core applications for KDE, the K Desktop
  Environment. These core packages include Konqueror, the web browser and
  file manager.

  A problem with the interaction between the Flash Player and the Konqueror
  web browser was found. The problem could lead to key presses leaking to the
  Flash Player applet instead of the browser (CVE-2007-2022).

  Users of Konqueror who have installed the Adobe Flash Player plugin should
  upgrade to these updated packages, which contain a patch provided by Dirk
  Müller that protects against this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0494.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kdebase packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"kdebase-3.5.4-13.6.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-devel-3.5.4-13.6.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-3.1.3-5.16", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-devel-3.1.3-5.16", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-3.3.1-5.19.rhel4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-devel-3.3.1-5.19.rhel4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-3.5.4-13.6.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-3.1.3-5.16", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-devel-3.1.3-5.16", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-3.3.1-5.19.rhel4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-devel-3.3.1-5.19.rhel4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-3.1.3-5.16", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-devel-3.1.3-5.16", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-3.3.1-5.19.rhel4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-devel-3.3.1-5.19.rhel4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"kdebase-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-2022", value:TRUE);
}
if ( rpm_exists(rpm:"kdebase-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-2022", value:TRUE);
}
if ( rpm_exists(rpm:"kdebase-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2022", value:TRUE);
}
if ( rpm_exists(rpm:"kdebase-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-2022", value:TRUE);
}
if ( rpm_exists(rpm:"kdebase-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-2022", value:TRUE);
}
if ( rpm_exists(rpm:"kdebase-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2022", value:TRUE);
}
if ( rpm_exists(rpm:"kdebase-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-2022", value:TRUE);
}
if ( rpm_exists(rpm:"kdebase-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2022", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0494", value:TRUE);
