#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25607);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3257");

 name["english"] = "RHSA-2007-0510: evolution";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated evolution-data-server package that fixes a security bug are now
  available for Red Hat Enterprise Linux 5.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  The evolution-data-server package provides a unified backend for programs
  that work with contacts, tasks, and calendar information.

  A flaw was found in the way evolution-data-server processes certain IMAP
  server messages. If a user can be tricked into connecting to a malicious
  IMAP server it may be possible to execute arbitrary code as the user
  running the evolution-data-server process. (CVE-2007-3257)

  All users of evolution-data-server should upgrade to these updated
  packages, which contain a backported patch which resolves this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0510.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the evolution packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"evolution-data-server-1.8.0-15.0.4.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution-data-server-devel-1.8.0-15.0.4.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution-data-server-1.8.0-15.0.4.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"evolution-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3257", value:TRUE);
}
if ( rpm_exists(rpm:"evolution-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3257", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0510", value:TRUE);
