#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26189);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4519", "CVE-2007-2949", "CVE-2007-3741");

 name["english"] = "RHSA-2007-0513: gimp";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated gimp packages that fix several security issues are now available
  for Red Hat Enterprise Linux.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The GIMP (GNU Image Manipulation Program) is an image composition and
  editing program.

  Multiple integer overflow and input validation flaws were found in The
  GIMP\'s image loaders. An attacker could create a carefully crafted image
  file that could cause The GIMP to crash or possibly execute arbitrary code
  if the file was opened by a victim. (CVE-2006-4519, CVE-2007-2949,
  CVE-2007-3741)

  Users of The GIMP should update to these erratum packages, which contain a
  backported fix to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0513.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gimp packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gimp-2.2.13-2.0.7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-2.2.13-2.0.7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-libs-2.2.13-2.0.7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-1.2.1-7.8.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-1.2.1-7.8.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-perl-1.2.1-7.8.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-1.2.3-20.9.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-1.2.3-20.9.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-perl-1.2.3-20.9.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-2.0.5-7.0.7.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-2.0.5-7.0.7.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-2.2.13-2.0.7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-libs-2.2.13-2.0.7.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-1.2.1-7.8.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-1.2.1-7.8.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-perl-1.2.1-7.8.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-2.0.5-7.0.7.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-2.0.5-7.0.7.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-1.2.1-7.8.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-1.2.1-7.8.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-perl-1.2.1-7.8.el2_1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-2.0.5-7.0.7.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gimp-devel-2.0.5-7.0.7.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"gimp-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2006-4519", value:TRUE);
 set_kb_item(name:"CVE-2007-2949", value:TRUE);
 set_kb_item(name:"CVE-2007-3741", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2006-4519", value:TRUE);
 set_kb_item(name:"CVE-2007-2949", value:TRUE);
 set_kb_item(name:"CVE-2007-3741", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-4519", value:TRUE);
 set_kb_item(name:"CVE-2007-2949", value:TRUE);
 set_kb_item(name:"CVE-2007-3741", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-4519", value:TRUE);
 set_kb_item(name:"CVE-2007-2949", value:TRUE);
 set_kb_item(name:"CVE-2007-3741", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2006-4519", value:TRUE);
 set_kb_item(name:"CVE-2007-2949", value:TRUE);
 set_kb_item(name:"CVE-2007-3741", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2006-4519", value:TRUE);
 set_kb_item(name:"CVE-2007-2949", value:TRUE);
 set_kb_item(name:"CVE-2007-3741", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-4519", value:TRUE);
 set_kb_item(name:"CVE-2007-2949", value:TRUE);
 set_kb_item(name:"CVE-2007-3741", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2006-4519", value:TRUE);
 set_kb_item(name:"CVE-2007-2949", value:TRUE);
 set_kb_item(name:"CVE-2007-3741", value:TRUE);
}
if ( rpm_exists(rpm:"gimp-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-4519", value:TRUE);
 set_kb_item(name:"CVE-2007-2949", value:TRUE);
 set_kb_item(name:"CVE-2007-3741", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0513", value:TRUE);
