#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25608);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5752", "CVE-2007-3304");

 name["english"] = "RHSA-2007-0532: apache";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated Apache httpd packages that correct two security issues are now
  available for Red Hat Enterprise Linux 2.1.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The Apache HTTP Server is a popular Web server.

  The Apache HTTP Server did not verify that a process was an Apache child
  process before sending it signals. A local attacker who has the ability to
  run scripts on the Apache HTTP Server could manipulate the scoreboard and
  cause arbitrary processes to be terminated, which could lead to a denial of
  service. (CVE-2007-3304)

  A flaw was found in the Apache HTTP Server mod_status module. Sites with
  the server-status page publicly accessible and ExtendedStatus enabled were
  vulnerable to a cross-site scripting attack. On Red Hat Enterprise Linux
  the server-status page is not enabled by default and it is best practice to
  not make this publicly available. (CVE-2006-5752)

  Users of Apache should upgrade to these updated packages, which contain
  backported patches to correct these issues. Users should restart Apache
  after installing this update.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0532.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"apache-1.3.27-12.ent", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"apache-devel-1.3.27-12.ent", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"apache-manual-1.3.27-12.ent", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"apache-1.3.27-12.ent", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"apache-devel-1.3.27-12.ent", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"apache-manual-1.3.27-12.ent", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"apache-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2006-5752", value:TRUE);
 set_kb_item(name:"CVE-2007-3304", value:TRUE);
}
if ( rpm_exists(rpm:"apache-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2006-5752", value:TRUE);
 set_kb_item(name:"CVE-2007-3304", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0532", value:TRUE);
