#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25984);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3849");

 name["english"] = "RHSA-2007-0539: aide";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated aide package that fixes various bugs is now available for Red
  Hat Enterprise Linux 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Advanced Intrusion Detection Environment (AIDE) is a file integrity checker
  and intrusion detection program.

  A flaw was discovered in the way file checksums were stored in the AIDE
  database. A packaging flaw in the Red Hat AIDE rpm resulted in the file
  database not containing any file checksum information. This could prevent
  AIDE from detecting certain file modifications. (CVE-2007-3849)

  This update also fixes the following bugs:

  * certain configurations could result in a segmentation fault upon
  initialization.

  * AIDE was unable to open its log file in the LSPP evaluated configuration.

  * if AIDE found SELinux context differences, the changed files report it
  generated only included the first 32 characters of the context.

  All users of AIDE are advised to upgrade to this updated package containing
  AIDE version 0.13.1 which is not vulnerable to these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0539.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the aide packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"aide-0.13.1-2.0.4.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"aide-0.13.1-2.0.4.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"aide-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3849", value:TRUE);
}
if ( rpm_exists(rpm:"aide-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3849", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0539", value:TRUE);
