#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28237);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2006-5052", "CVE-2007-3102");

 name["english"] = "RHSA-2007-0703: openssh";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated openssh packages that fix two security issues and various bugs are
  now available.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  OpenSSH is OpenBSD\'s SSH (Secure SHell) protocol implementation. These
  packages include the core files necessary for both the OpenSSH client and
  server.

  A flaw was found in the way the ssh server wrote account names to the
  audit subsystem. An attacker could inject strings containing parts of audit
  messages which could possibly mislead or confuse audit log parsing tools.
  (CVE-2007-3102)

  A flaw was found in the way the OpenSSH server processes GSSAPI
  authentication requests. When GSSAPI authentication was enabled in OpenSSH
  server, a remote attacker may have been able to determine if a username is
  valid. (CVE-2006-5052)

  The following bugs were also fixed:

  * the ssh daemon did not generate audit messages when an ssh session was
  closed.

  * GSSAPI authentication sometimes failed on clusters using DNS or
  load-balancing.

  * the sftp client and server leaked small amounts of memory in some cases.

  * the sftp client didn\'t properly exit and return non-zero status in batch
  mode when the destination disk drive was full.

  * when restarting the ssh daemon with the initscript, the ssh daemon was
  sometimes not restarted successfully because the old running ssh daemon was
  not properly killed.

  * with challenge/response authentication enabled, the pam sub-process was
  not terminated if the user authentication timed out.

  All users of openssh should upgrade to these updated packages, which
  contain patches to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0703.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openssh packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"openssh-3.9p1-8.RHEL4.24", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-askpass-3.9p1-8.RHEL4.24", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-askpass-gnome-3.9p1-8.RHEL4.24", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-clients-3.9p1-8.RHEL4.24", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-server-3.9p1-8.RHEL4.24", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-3.9p1-8.RHEL4.24", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-askpass-3.9p1-8.RHEL4.24", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-askpass-gnome-3.9p1-8.RHEL4.24", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-clients-3.9p1-8.RHEL4.24", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-server-3.9p1-8.RHEL4.24", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-3.9p1-8.RHEL4.24", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-askpass-3.9p1-8.RHEL4.24", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-askpass-gnome-3.9p1-8.RHEL4.24", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-clients-3.9p1-8.RHEL4.24", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-server-3.9p1-8.RHEL4.24", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"openssh-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-5052", value:TRUE);
 set_kb_item(name:"CVE-2007-3102", value:TRUE);
}
if ( rpm_exists(rpm:"openssh-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-5052", value:TRUE);
 set_kb_item(name:"CVE-2007-3102", value:TRUE);
}
if ( rpm_exists(rpm:"openssh-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-5052", value:TRUE);
 set_kb_item(name:"CVE-2007-3102", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0703", value:TRUE);
