#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27833);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3389", "CVE-2007-3390", "CVE-2007-3391", "CVE-2007-3392", "CVE-2007-3393");

 name["english"] = "RHSA-2007-0710: wireshark";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  New Wireshark packages that fix various security vulnerabilities are now
  available for Red Hat Enterprise Linux 5. Wireshark was previously known
  as Ethereal.

  This update has been rated as having low security impact by the Red Hat
  Security Response Team.

  Wireshark is a program for monitoring network traffic.

  Several denial of service bugs were found in Wireshark\'s HTTP, iSeries, DCP
  ETSI, SSL, MMS, DHCP and BOOTP protocol dissectors. It was possible for
  Wireshark to crash or stop responding if it read a malformed packet off the
  network. (CVE-2007-3389, CVE-2007-3390, CVE-2007-3391, CVE-2007-3392,
  CVE-2007-3393)

  Users of Wireshark and Ethereal should upgrade to these updated packages,
  containing Wireshark version 0.99.6, which is not vulnerable to these
  issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0710.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wireshark packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"wireshark-0.99.6-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-gnome-0.99.6-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-0.99.6-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"wireshark-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3389", value:TRUE);
 set_kb_item(name:"CVE-2007-3390", value:TRUE);
 set_kb_item(name:"CVE-2007-3391", value:TRUE);
 set_kb_item(name:"CVE-2007-3392", value:TRUE);
 set_kb_item(name:"CVE-2007-3393", value:TRUE);
}
if ( rpm_exists(rpm:"wireshark-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3389", value:TRUE);
 set_kb_item(name:"CVE-2007-3390", value:TRUE);
 set_kb_item(name:"CVE-2007-3391", value:TRUE);
 set_kb_item(name:"CVE-2007-3392", value:TRUE);
 set_kb_item(name:"CVE-2007-3393", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0710", value:TRUE);
