#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25877);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0235");

 name["english"] = "RHSA-2007-0765: libgtop";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated libgtop2 package that fixes a security issue and a functionality
  bug is now available for Red Hat Enterprise Linux 4.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The libgtop2 package contains a library for obtaining information about a
  running system, such as cpu, memory and disk usage; active processes; and
  PIDs.

  A flaw was found in the way libgtop2 handled long filenames mapped
  into the address space of a process. An attacker could execute arbitrary
  code on behalf of the user running gnome-system-monitor by executing a
  process and mapping a file with a specially crafted name into the
  processes\' address space. (CVE-2007-0235)

  This update also fixes the following bug:

  * when a version of libgtop2 compiled to run on a 32-bit architecture was
  used to inspect a process running in 64-bit mode, it failed to report
  certain information regarding address space mapping correctly.

  All users of gnome-system-monitor are advised to upgrade to this updated
  libgtop2 package, which contains backported patches that resolve these
  issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0765.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libgtop packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libgtop2-2.8.0-1.0.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgtop2-devel-2.8.0-1.0.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgtop2-2.8.0-1.0.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgtop2-devel-2.8.0-1.0.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgtop2-2.8.0-1.0.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgtop2-devel-2.8.0-1.0.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"libgtop-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-0235", value:TRUE);
}
if ( rpm_exists(rpm:"libgtop-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-0235", value:TRUE);
}
if ( rpm_exists(rpm:"libgtop-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-0235", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0765", value:TRUE);
