#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25878);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3381");

 name["english"] = "RHSA-2007-0777: gdm";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated gdm package that fixes a security issue is now available for Red
  Hat Enterprise Linux 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Gdm (the GNOME Display Manager) is a highly configurable reimplementation
  of xdm, the X Display Manager. Gdm allows you to log into your system with
  the X Window System running and supports running several different X
  sessions on your local machine at the same time.

  A flaw was found in the way Gdm listens on its unix domain socket. A local
  user could crash a running X session by writing malicious data to Gdm\'s
  unix domain socket. (CVE-2007-3381)

  All users of gdm should upgrade to this updated package, which contains a
  backported patch that resolves this issue.

  Red Hat would like to thank JLANTHEA for reporting this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0777.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gdm packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gdm-2.16.0-31.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gdm-2.16.0-31.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"gdm-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3381", value:TRUE);
}
if ( rpm_exists(rpm:"gdm-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3381", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0777", value:TRUE);
