#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28241);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2006-4624");

 name["english"] = "RHSA-2007-0779: mailman";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated mailman packages that fix a security issue and various bugs are now
  available for Red Hat Enterprise Linux 4.

  This update has been rated as having low security impact by the Red Hat
  Security Response Team.

  Mailman is a program used to help manage email discussion lists.

  A flaw was found in Mailman. A remote attacker could spoof messages in
  the error log, and possibly trick the administrator into visiting malicious
  URLs via a carriage return/line feed sequence in the URI. (CVE-2006-4624)

  As well, these updated packages fix the following bugs:

  * canceling a subscription on the confirm subscription request page
  caused mailman to crash.

  * editing the sender filter caused all spam filter rules to be deleted.

  * the migrate-fhs script was not included.

  * the mailman init script returned a zero (success) exit code even when
  an incorrect command was given. For example, the "mailman foo" command
  returned a zero exit code. In these updated packages the mailmain init
  script returns the correct exit codes.

  Users of Mailman are advised to upgrade to these updated packages, which
  resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0779.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mailman packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"mailman-2.1.5.1-34.rhel4.6", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mailman-2.1.5.1-34.rhel4.6", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mailman-2.1.5.1-34.rhel4.6", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"mailman-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-4624", value:TRUE);
}
if ( rpm_exists(rpm:"mailman-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-4624", value:TRUE);
}
if ( rpm_exists(rpm:"mailman-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-4624", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0779", value:TRUE);
