#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26108);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3106", "CVE-2007-4029", "CVE-2007-4065", "CVE-2007-4066");

 name["english"] = "RHSA-2007-0845: libvorbis";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated libvorbis packages to correct several security issues are now
  available for Red Hat Enterprise Linux 3, 4, and 5.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  The libvorbis package contains runtime libraries for use in programs that
  support Ogg Voribs. Ogg Vorbis is a fully open, non-proprietary, patent-and
  royalty-free, general-purpose compressed audio format.

  Several flaws were found in the way libvorbis processed audio data. An
  attacker could create a carefully crafted OGG audio file in such a way that
  it could cause an application linked with libvorbis to crash or execute
  arbitrary code when it was opened. (CVE-2007-3106, CVE-2007-4029,
  CVE-2007-4065, CVE-2007-4066)

  Users of libvorbis are advised to upgrade to this updated package, which
  contains backported patches that resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0845.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libvorbis packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libvorbis-1.1.2-3.el5.0", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis-devel-1.1.2-3.el5.0", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis-1.0-8.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis-devel-1.0-8.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis-1.1.0-2.el4.5", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis-devel-1.1.0-2.el4.5", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis-1.1.2-3.el5.0", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis-1.0-8.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis-devel-1.0-8.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis-1.1.0-2.el4.5", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis-devel-1.1.0-2.el4.5", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis-1.0-8.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis-devel-1.0-8.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis-1.1.0-2.el4.5", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libvorbis-devel-1.1.0-2.el4.5", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"libvorbis-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3106", value:TRUE);
 set_kb_item(name:"CVE-2007-4029", value:TRUE);
 set_kb_item(name:"CVE-2007-4065", value:TRUE);
 set_kb_item(name:"CVE-2007-4066", value:TRUE);
}
if ( rpm_exists(rpm:"libvorbis-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-3106", value:TRUE);
 set_kb_item(name:"CVE-2007-4029", value:TRUE);
 set_kb_item(name:"CVE-2007-4065", value:TRUE);
 set_kb_item(name:"CVE-2007-4066", value:TRUE);
}
if ( rpm_exists(rpm:"libvorbis-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3106", value:TRUE);
 set_kb_item(name:"CVE-2007-4029", value:TRUE);
 set_kb_item(name:"CVE-2007-4065", value:TRUE);
 set_kb_item(name:"CVE-2007-4066", value:TRUE);
}
if ( rpm_exists(rpm:"libvorbis-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3106", value:TRUE);
 set_kb_item(name:"CVE-2007-4029", value:TRUE);
 set_kb_item(name:"CVE-2007-4065", value:TRUE);
 set_kb_item(name:"CVE-2007-4066", value:TRUE);
}
if ( rpm_exists(rpm:"libvorbis-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-3106", value:TRUE);
 set_kb_item(name:"CVE-2007-4029", value:TRUE);
 set_kb_item(name:"CVE-2007-4065", value:TRUE);
 set_kb_item(name:"CVE-2007-4066", value:TRUE);
}
if ( rpm_exists(rpm:"libvorbis-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3106", value:TRUE);
 set_kb_item(name:"CVE-2007-4029", value:TRUE);
 set_kb_item(name:"CVE-2007-4065", value:TRUE);
 set_kb_item(name:"CVE-2007-4066", value:TRUE);
}
if ( rpm_exists(rpm:"libvorbis-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-3106", value:TRUE);
 set_kb_item(name:"CVE-2007-4029", value:TRUE);
 set_kb_item(name:"CVE-2007-4065", value:TRUE);
 set_kb_item(name:"CVE-2007-4066", value:TRUE);
}
if ( rpm_exists(rpm:"libvorbis-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3106", value:TRUE);
 set_kb_item(name:"CVE-2007-4029", value:TRUE);
 set_kb_item(name:"CVE-2007-4065", value:TRUE);
 set_kb_item(name:"CVE-2007-4066", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0845", value:TRUE);
