#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25987);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3999", "CVE-2007-4000");

 name["english"] = "RHSA-2007-0858: krb";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated krb5 packages that fix two security flaws are now available for
  Red Hat Enterprise Linux 5.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  Kerberos is a network authentication system which allows clients and
  servers to authenticate to each other through use of symmetric encryption
  and a trusted third party, the KDC. kadmind is the KADM5 administration
  server.

  Tenable Network Security discovered a stack buffer overflow flaw in the RPC
  library used by kadmind. A remote unauthenticated attacker who can access
  kadmind could trigger this flaw and cause kadmind to crash. On Red Hat
  Enterprise Linux 5 it is not possible to exploit this flaw to run arbitrary
  code as the overflow is blocked by FORTIFY_SOURCE. (CVE-2007-3999)

  Garrett Wollman discovered an uninitialized pointer flaw in kadmind. A
  remote unauthenticated attacker who can access kadmind could trigger this
  flaw and cause kadmind to crash. (CVE-2007-4000)

  These issues did not affect the versions of Kerberos distributed with Red
  Hat Enterprise Linux 2.1, 3, or 4.

  Users of krb5-server are advised to update to these erratum packages which
  contain backported fixes to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0858.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the krb packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"krb5-devel-1.5-28", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-libs-1.5-28", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-server-1.5-28", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-workstation-1.5-28", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-libs-1.5-28", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-workstation-1.5-28", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"krb-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3999", value:TRUE);
 set_kb_item(name:"CVE-2007-4000", value:TRUE);
}
if ( rpm_exists(rpm:"krb-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3999", value:TRUE);
 set_kb_item(name:"CVE-2007-4000", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0858", value:TRUE);
