#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25948);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-4131");

 name["english"] = "RHSA-2007-0860: tar";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated tar package that fixes a path traversal flaw is now available.

  This update has been rated as having moderate security impact by the Red
  Hat
  Security Response Team.

  The GNU tar program saves many files together in one archive and can
  restore individual files (or all of the files) from that archive.

  A path traversal flaw was discovered in the way GNU tar extracted archives.
  A malicious user could create a tar archive that could write to arbitrary
  files to which the user running GNU tar had write access. (CVE-2007-4131)

  Red Hat would like to thank Dmitry V. Levin for reporting this issue.

  Users of tar should upgrade to this updated package, which contains a
  replacement backported patch to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0860.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tar packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"tar-1.15.1-23.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tar-1.14-12.5.1.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tar-1.15.1-23.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tar-1.14-12.5.1.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tar-1.14-12.5.1.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"tar-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4131", value:TRUE);
}
if ( rpm_exists(rpm:"tar-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-4131", value:TRUE);
}
if ( rpm_exists(rpm:"tar-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4131", value:TRUE);
}
if ( rpm_exists(rpm:"tar-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-4131", value:TRUE);
}
if ( rpm_exists(rpm:"tar-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-4131", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0860", value:TRUE);
