#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26190);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3382", "CVE-2007-3385", "CVE-2007-3386");

 name["english"] = "RHSA-2007-0871: tomcat";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated tomcat packages that fix several security issues are now available
  for Red Hat Enterprise Linux 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Tomcat is a servlet container for Java Servlet and Java Server Pages
  technologies.

  Tomcat was found treating single quote characters -- \' -- as delimiters in
  cookies. This could allow remote attackers to obtain sensitive information,
  such as session IDs, for session hijacking attacks (CVE-2007-3382).

  It was reported Tomcat did not properly handle the following character
  sequence in a cookie: \" (a backslash followed by a double-quote). It was
  possible remote attackers could use this failure to obtain sensitive
  information, such as session IDs, for session hijacking attacks
  (CVE-2007-3385).

  A cross-site scripting (XSS) vulnerability existed in the Host Manager
  Servlet. This allowed remote attackers to inject arbitrary HTML and web
  script via crafted requests (CVE-2007-3386).

  Users of Tomcat should update to these erratum packages, which contain
  backported patches and are not vulnerable to these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0871.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tomcat packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"tomcat5-5.5.23-0jpp.3.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tomcat5-admin-webapps-5.5.23-0jpp.3.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tomcat5-common-lib-5.5.23-0jpp.3.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tomcat5-jasper-5.5.23-0jpp.3.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tomcat5-jasper-javadoc-5.5.23-0jpp.3.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tomcat5-jsp-2.0-api-5.5.23-0jpp.3.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tomcat5-jsp-2.0-api-javadoc-5.5.23-0jpp.3.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tomcat5-server-lib-5.5.23-0jpp.3.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tomcat5-servlet-2.4-api-5.5.23-0jpp.3.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tomcat5-servlet-2.4-api-javadoc-5.5.23-0jpp.3.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tomcat5-webapps-5.5.23-0jpp.3.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tomcat5-jsp-2.0-api-5.5.23-0jpp.3.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tomcat5-servlet-2.4-api-5.5.23-0jpp.3.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"tomcat-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3382", value:TRUE);
 set_kb_item(name:"CVE-2007-3385", value:TRUE);
 set_kb_item(name:"CVE-2007-3386", value:TRUE);
}
if ( rpm_exists(rpm:"tomcat-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3382", value:TRUE);
 set_kb_item(name:"CVE-2007-3385", value:TRUE);
 set_kb_item(name:"CVE-2007-3386", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0871", value:TRUE);
