#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26951);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3820", "CVE-2007-4224", "CVE-2007-4569");

 name["english"] = "RHSA-2007-0905: kdebase";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated kdebase packages that resolve several security flaws are now
  available for Red Hat Enterprise Linux 4 and 5.

  This update has been rated as having moderate security impact by the Red
  Hat
  Security Response Team.

  The kdebase packages provide the core applications for KDE, the K Desktop
  Environment. These core packages include Konqueror, the web browser and
  file manager.

  These updated packages address the following vulnerabilities:

  Kees Huijgen found a flaw in the way KDM handled logins when autologin and
  "shutdown with password" were enabled. A local user would have been able
  to login via KDM as any user without requiring a password. (CVE-2007-4569)

  Two Konqueror address spoofing flaws were discovered. A malicious web site
  could spoof the Konqueror address bar, tricking a victim into believing the
  page was from a different site. (CVE-2007-3820, CVE-2007-4224)

  Users of KDE should upgrade to these updated packages, which contain
  backported patches to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0905.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kdebase packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"kdebase-3.5.4-15.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-devel-3.5.4-15.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-3.3.1-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-devel-3.3.1-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-3.5.4-15.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-3.3.1-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-devel-3.3.1-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-3.3.1-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kdebase-devel-3.3.1-6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"kdebase-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3820", value:TRUE);
 set_kb_item(name:"CVE-2007-4224", value:TRUE);
 set_kb_item(name:"CVE-2007-4569", value:TRUE);
}
if ( rpm_exists(rpm:"kdebase-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3820", value:TRUE);
 set_kb_item(name:"CVE-2007-4224", value:TRUE);
 set_kb_item(name:"CVE-2007-4569", value:TRUE);
}
if ( rpm_exists(rpm:"kdebase-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3820", value:TRUE);
 set_kb_item(name:"CVE-2007-4224", value:TRUE);
 set_kb_item(name:"CVE-2007-4569", value:TRUE);
}
if ( rpm_exists(rpm:"kdebase-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3820", value:TRUE);
 set_kb_item(name:"CVE-2007-4224", value:TRUE);
 set_kb_item(name:"CVE-2007-4569", value:TRUE);
}
if ( rpm_exists(rpm:"kdebase-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3820", value:TRUE);
 set_kb_item(name:"CVE-2007-4224", value:TRUE);
 set_kb_item(name:"CVE-2007-4569", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0905", value:TRUE);
