#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28242);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5191");

 name["english"] = "RHSA-2007-0969: util";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated util-linux packages that fix a security issue are now available for
  Red Hat Enterprise Linux 3, 4, and 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The util-linux package contains a large variety of low-level system
  utilities that are necessary for a Linux system to function.

  A flaw was discovered in the way that the mount and umount utilities
  used the setuid and setgid functions, which could lead to privileges being
  dropped improperly. A local user could use this flaw to run mount helper
  applications such as, mount.nfs, with additional privileges (CVE-2007-5191).

  Users are advised to update to these erratum packages which contain a
  backported patch to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0969.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the util packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"util-linux-2.13-0.45.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"losetup-2.11y-31.24", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mount-2.11y-31.24", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"util-linux-2.11y-31.24", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"util-linux-2.12a-17.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"util-linux-2.13-0.45.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"losetup-2.11y-31.24", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mount-2.11y-31.24", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"util-linux-2.11y-31.24", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"util-linux-2.12a-17.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"losetup-2.11y-31.24", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mount-2.11y-31.24", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"util-linux-2.11y-31.24", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"util-linux-2.12a-17.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"util-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-5191", value:TRUE);
}
if ( rpm_exists(rpm:"util-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-5191", value:TRUE);
}
if ( rpm_exists(rpm:"util-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-5191", value:TRUE);
}
if ( rpm_exists(rpm:"util-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-5191", value:TRUE);
}
if ( rpm_exists(rpm:"util-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-5191", value:TRUE);
}
if ( rpm_exists(rpm:"util-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-5191", value:TRUE);
}
if ( rpm_exists(rpm:"util-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-5191", value:TRUE);
}
if ( rpm_exists(rpm:"util-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-5191", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0969", value:TRUE);
