#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27837);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");

 name["english"] = "RHSA-2007-1026: poppler";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated poppler packages that fix several security issues are now available
  for Red Hat Enterprise Linux 5.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  Poppler is a PDF rendering library, used by applications such as evince.

  Alin Rad Pop discovered several flaws in the handling of PDF files. An
  attacker could create a malicious PDF file that would cause an application
  linked with poppler to crash, or potentially execute arbitrary code when
  opened. (CVE-2007-4352, CVE-2007-5392, CVE-2007-5393)

  Users are advised to upgrade to these updated packages, which contain
  backported patches to resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-1026.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the poppler packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"poppler-0.5.4-4.3.el5_1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"poppler-devel-0.5.4-4.3.el5_1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"poppler-utils-0.5.4-4.3.el5_1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"poppler-0.5.4-4.3.el5_1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"poppler-utils-0.5.4-4.3.el5_1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"poppler-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4352", value:TRUE);
 set_kb_item(name:"CVE-2007-5392", value:TRUE);
 set_kb_item(name:"CVE-2007-5393", value:TRUE);
}
if ( rpm_exists(rpm:"poppler-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4352", value:TRUE);
 set_kb_item(name:"CVE-2007-5392", value:TRUE);
 set_kb_item(name:"CVE-2007-5393", value:TRUE);
}

set_kb_item(name:"RHSA-2007-1026", value:TRUE);
