#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28169);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2005-4872");
 script_cve_id("CVE-2006-7227");

 name["english"] = "RHSA-2007-1052: pcre";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated pcre packages that correct security issues are now available for
  Red Hat Enterprise Linux 4 and 5.

  This update has been rated as having critical security impact by the Red
  Hat Security Response Team.

  PCRE is a Perl-compatible regular expression library.

  Flaws were found in the way PCRE handles certain malformed regular
  expressions. If an application linked against PCRE, such as Konqueror,
  parses a malicious regular expression, it may be possible to run arbitrary
  code as the user running the application. (CVE-2006-7224)

  Users of PCRE are advised to upgrade to these updated packages, which
  contain a backported patch to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-1052.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pcre packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"pcre-6.6-2.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pcre-devel-6.6-2.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pcre-4.5-4.el4_5.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pcre-devel-4.5-4.el4_5.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pcre-6.6-2.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pcre-4.5-4.el4_5.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pcre-devel-4.5-4.el4_5.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pcre-4.5-4.el4_5.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pcre-devel-4.5-4.el4_5.4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"pcre-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2006-7224", value:TRUE);
}
if ( rpm_exists(rpm:"pcre-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-7224", value:TRUE);
}
if ( rpm_exists(rpm:"pcre-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2006-7224", value:TRUE);
}
if ( rpm_exists(rpm:"pcre-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-7224", value:TRUE);
}
if ( rpm_exists(rpm:"pcre-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-7224", value:TRUE);
}

set_kb_item(name:"RHSA-2007-1052", value:TRUE);
