#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28365);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2006-7228", "CVE-2007-1660");

 name["english"] = "RHSA-2007-1063: pcre";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated pcre packages that resolve several security issues are now
  available for Red Hat Enterprise Linux 3.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  PCRE is a Perl-compatible regular expression library.

  Flaws were discovered in the way PCRE handles certain malformed regular
  expressions. If an application linked against PCRE, such as Konqueror,
  parsed a malicious regular expression, it may have been possible to run
  arbitrary code as the user running the application. (CVE-2006-7228,
  CVE-2007-1660)

  Users of PCRE are advised to upgrade to these updated packages, which
  contain backported patches to resolve these issues.

  Red Hat would like to thank Ludwig Nussel for reporting these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-1063.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pcre packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"pcre-3.9-10.4", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pcre-devel-3.9-10.4", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pcre-3.9-10.4", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pcre-devel-3.9-10.4", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pcre-3.9-10.4", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"pcre-devel-3.9-10.4", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"pcre-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-7228", value:TRUE);
 set_kb_item(name:"CVE-2007-1660", value:TRUE);
}
if ( rpm_exists(rpm:"pcre-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-7228", value:TRUE);
 set_kb_item(name:"CVE-2007-1660", value:TRUE);
}
if ( rpm_exists(rpm:"pcre-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-7228", value:TRUE);
 set_kb_item(name:"CVE-2007-1660", value:TRUE);
}

set_kb_item(name:"RHSA-2007-1063", value:TRUE);
