#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28368);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5503");

 name["english"] = "RHSA-2007-1078: cairo";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated Cairo packages that resolve a security issue are now available for
  Red Hat Enterprise Linux 5.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  Cairo is a vector graphics library designed to provide high-quality display
  and print output.

  An integer overflow flaw was found in the way Cairo processes PNG images.
  If an application linked against Cairo processes a malicious PNG image, it
  is possible to execute arbitrary code as the user running the application.
  (CVE-2007-5503)

  Users of Cairo are advised to upgrade to these updated packages, which
  contain a backported patch to resolve this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-1078.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cairo packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"cairo-1.2.4-3.el5_1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cairo-devel-1.2.4-3.el5_1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cairo-1.2.4-3.el5_1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"cairo-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-5503", value:TRUE);
}
if ( rpm_exists(rpm:"cairo-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-5503", value:TRUE);
}

set_kb_item(name:"RHSA-2007-1078", value:TRUE);
