#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29204);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-6110");

 name["english"] = "RHSA-2007-1095: htdig";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated htdig packages that resolve a security issue are now available for
  Red Hat Enterprise Linux 4 and 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The ht://Dig system is a complete World Wide Web indexing and searching
  system for a small domain or intranet.

  A cross-site scripting flaw was discovered in a htdig search page. An
  attacker could construct a carefully crafted URL, which once visited by an
  unsuspecting user, could cause a user\'s Web browser to execute malicious
  script in the context of the visited htdig search Web page. (CVE-2007-6110)

  Users of htdig are advised to upgrade to these updated packages, which
  contain backported patch to resolve this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-1095.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the htdig packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"htdig-3.2.0b6-9.0.1.el5_1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"htdig-web-3.2.0b6-9.0.1.el5_1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"htdig-3.2.0b6-4.el4_6", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"htdig-web-3.2.0b6-4.el4_6", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"htdig-3.2.0b6-9.0.1.el5_1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"htdig-3.2.0b6-4.el4_6", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"htdig-web-3.2.0b6-4.el4_6", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"htdig-3.2.0b6-4.el4_6", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"htdig-web-3.2.0b6-4.el4_6", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"htdig-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-6110", value:TRUE);
}
if ( rpm_exists(rpm:"htdig-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-6110", value:TRUE);
}
if ( rpm_exists(rpm:"htdig-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-6110", value:TRUE);
}
if ( rpm_exists(rpm:"htdig-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-6110", value:TRUE);
}
if ( rpm_exists(rpm:"htdig-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-6110", value:TRUE);
}

set_kb_item(name:"RHSA-2007-1095", value:TRUE);
