#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29692);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5964");

 name["english"] = "RHSA-2007-1128: autofs";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated autofs packages are now available to fix a security flaw for Red
  Hat Enterprise Linux 5.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  The autofs utility controls the operation of the automount daemon, which
  automatically mounts and unmounts file systems after a period of
  inactivity.

  There was a security issue with the default installed configuration of
  autofs version 5 whereby the entry for the "hosts" map did not specify the
  "nosuid" mount option. A local user with control of a remote nfs server
  could create a setuid root executable within an exported filesystem on the
  remote nfs server that, if mounted using the default hosts map, would allow
  the user to gain root privileges. (CVE-2007-5964)

  Due to the fact that autofs always mounted hosts map entries suid by
  default, autofs has now been altered to always use the "nosuid" option when
  mounting from the default hosts map. The "suid" option must be explicitly
  given in the master map entry to revert to the old behavior. This change
  affects only the hosts map which corresponds to the /net entry in the
  default configuration.

  Users are advised to upgrade to these updated autofs packages, which
  resolve this issue.

  Red Hat would like to thank Josh Lange for reporting this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-1128.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the autofs packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"autofs-5.0.1-0.rc2.55.el5.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"autofs-5.0.1-0.rc2.55.el5.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"autofs-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-5964", value:TRUE);
}
if ( rpm_exists(rpm:"autofs-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-5964", value:TRUE);
}

set_kb_item(name:"RHSA-2007-1128", value:TRUE);
