#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29955);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3278", "CVE-2007-4769", "CVE-2007-4772", "CVE-2007-6067", "CVE-2007-6600", "CVE-2007-6601");

 name["english"] = "RHSA-2008-0038: postgresql";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated postgresql packages that fix several security issues are now
  available for Red Hat Enterprise Linux 4 and 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  PostgreSQL is an advanced Object-Relational database management system
  (DBMS). The postgresql packages include the client programs and libraries
  needed to access a PostgreSQL DBMS server.

  Will Drewry discovered multiple flaws in PostgreSQL\'s regular expression
  engine. An authenticated attacker could use these flaws to cause a denial
  of service by causing the PostgreSQL server to crash, enter an infinite
  loop, or use extensive CPU and memory resources while processing queries
  containing specially crafted regular expressions. Applications that accept
  regular expressions from untrusted sources may expose this problem to
  unauthorized attackers. (CVE-2007-4769, CVE-2007-4772, CVE-2007-6067)

  A privilege escalation flaw was discovered in PostgreSQL. An authenticated
  attacker could create an index function that would be executed with
  administrator privileges during database maintenance tasks, such as
  database vacuuming. (CVE-2007-6600)

  A privilege escalation flaw was discovered in PostgreSQL\'s Database Link
  library (dblink). An authenticated attacker could use dblink to possibly
  escalate privileges on systems with "trust" or "ident" authentication
  configured. Please note that dblink functionality is not enabled by
  default, and can only by enabled by a database administrator on systems
  with the postgresql-contrib package installed. (CVE-2007-3278,
  CVE-2007-6601)

  All postgresql users should upgrade to these updated packages, which
  include PostgreSQL 7.4.19 and 8.1.11, and resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2008-0038.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the postgresql packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"postgresql-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-contrib-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-devel-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-docs-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-libs-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-pl-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-python-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-server-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-tcl-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-test-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-contrib-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-devel-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-docs-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-jdbc-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-libs-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-pl-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-python-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-server-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-tcl-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-test-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-contrib-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-docs-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-libs-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-python-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-tcl-8.1.11-1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-contrib-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-devel-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-docs-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-jdbc-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-libs-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-pl-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-python-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-server-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-tcl-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-test-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-contrib-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-devel-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-docs-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-jdbc-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-libs-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-pl-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-python-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-server-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-tcl-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"postgresql-test-7.4.19-1.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"postgresql-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3278", value:TRUE);
 set_kb_item(name:"CVE-2007-4769", value:TRUE);
 set_kb_item(name:"CVE-2007-4772", value:TRUE);
 set_kb_item(name:"CVE-2007-6067", value:TRUE);
 set_kb_item(name:"CVE-2007-6600", value:TRUE);
 set_kb_item(name:"CVE-2007-6601", value:TRUE);
}
if ( rpm_exists(rpm:"postgresql-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3278", value:TRUE);
 set_kb_item(name:"CVE-2007-4769", value:TRUE);
 set_kb_item(name:"CVE-2007-4772", value:TRUE);
 set_kb_item(name:"CVE-2007-6067", value:TRUE);
 set_kb_item(name:"CVE-2007-6600", value:TRUE);
 set_kb_item(name:"CVE-2007-6601", value:TRUE);
}
if ( rpm_exists(rpm:"postgresql-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3278", value:TRUE);
 set_kb_item(name:"CVE-2007-4769", value:TRUE);
 set_kb_item(name:"CVE-2007-4772", value:TRUE);
 set_kb_item(name:"CVE-2007-6067", value:TRUE);
 set_kb_item(name:"CVE-2007-6600", value:TRUE);
 set_kb_item(name:"CVE-2007-6601", value:TRUE);
}
if ( rpm_exists(rpm:"postgresql-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3278", value:TRUE);
 set_kb_item(name:"CVE-2007-4769", value:TRUE);
 set_kb_item(name:"CVE-2007-4772", value:TRUE);
 set_kb_item(name:"CVE-2007-6067", value:TRUE);
 set_kb_item(name:"CVE-2007-6600", value:TRUE);
 set_kb_item(name:"CVE-2007-6601", value:TRUE);
}
if ( rpm_exists(rpm:"postgresql-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3278", value:TRUE);
 set_kb_item(name:"CVE-2007-4769", value:TRUE);
 set_kb_item(name:"CVE-2007-4772", value:TRUE);
 set_kb_item(name:"CVE-2007-6067", value:TRUE);
 set_kb_item(name:"CVE-2007-6600", value:TRUE);
 set_kb_item(name:"CVE-2007-6601", value:TRUE);
}

set_kb_item(name:"RHSA-2008-0038", value:TRUE);
