#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(30035);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3389", "CVE-2007-3390", "CVE-2007-3391", "CVE-2007-3392", "CVE-2007-3393", "CVE-2007-6113", "CVE-2007-6114", "CVE-2007-6115", "CVE-2007-6117", "CVE-2007-6118", "CVE-2007-6120", "CVE-2007-6121", "CVE-2007-6450", "CVE-2007-6451");

 name["english"] = "RHSA-2008-0059: libsmi";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated wireshark packages that fix several security issues are now
  available for Red Hat Enterprise Linux 3.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Wireshark is a program for monitoring network traffic. Wireshark was
  previously known as Ethereal.

  Several flaws were found in Wireshark. Wireshark could crash or possibly
  execute arbitrary code as the user running Wireshark if it read a malformed
  packet off the network. (CVE-2007-6114, CVE-2007-6115, CVE-2007-6117)

  Several denial of service bugs were found in Wireshark. Wireshark could
  crash or stop responding if it read a malformed packet off the network.
  (CVE-2007-3389, CVE-2007-3390, CVE-2007-3391, CVE-2007-3392, CVE-2007-3392,
  CVE-2007-3393, CVE-2007-6113, CVE-2007-6118, CVE-2007-6120, CVE-2007-6121,
  CVE-2007-6450, CVE-2007-6451)

  As well, Wireshark switched from using net-snmp to libsmi, which is
  included in this errata.

  Users of wireshark should upgrade to these updated packages, which contain
  Wireshark version 0.99.7, and resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2008-0059.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libsmi packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libsmi-0.4.5-3.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libsmi-devel-0.4.5-3.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-0.99.7-EL3.1", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-gnome-0.99.7-EL3.1", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libsmi-0.4.5-3.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libsmi-devel-0.4.5-3.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-0.99.7-EL3.1", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-gnome-0.99.7-EL3.1", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libsmi-0.4.5-3.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libsmi-devel-0.4.5-3.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-0.99.7-EL3.1", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"wireshark-gnome-0.99.7-EL3.1", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"libsmi-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-3389", value:TRUE);
 set_kb_item(name:"CVE-2007-3390", value:TRUE);
 set_kb_item(name:"CVE-2007-3391", value:TRUE);
 set_kb_item(name:"CVE-2007-3392", value:TRUE);
 set_kb_item(name:"CVE-2007-3393", value:TRUE);
 set_kb_item(name:"CVE-2007-6113", value:TRUE);
 set_kb_item(name:"CVE-2007-6114", value:TRUE);
 set_kb_item(name:"CVE-2007-6115", value:TRUE);
 set_kb_item(name:"CVE-2007-6117", value:TRUE);
 set_kb_item(name:"CVE-2007-6118", value:TRUE);
 set_kb_item(name:"CVE-2007-6120", value:TRUE);
 set_kb_item(name:"CVE-2007-6121", value:TRUE);
 set_kb_item(name:"CVE-2007-6450", value:TRUE);
 set_kb_item(name:"CVE-2007-6451", value:TRUE);
}
if ( rpm_exists(rpm:"libsmi-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-3389", value:TRUE);
 set_kb_item(name:"CVE-2007-3390", value:TRUE);
 set_kb_item(name:"CVE-2007-3391", value:TRUE);
 set_kb_item(name:"CVE-2007-3392", value:TRUE);
 set_kb_item(name:"CVE-2007-3393", value:TRUE);
 set_kb_item(name:"CVE-2007-6113", value:TRUE);
 set_kb_item(name:"CVE-2007-6114", value:TRUE);
 set_kb_item(name:"CVE-2007-6115", value:TRUE);
 set_kb_item(name:"CVE-2007-6117", value:TRUE);
 set_kb_item(name:"CVE-2007-6118", value:TRUE);
 set_kb_item(name:"CVE-2007-6120", value:TRUE);
 set_kb_item(name:"CVE-2007-6121", value:TRUE);
 set_kb_item(name:"CVE-2007-6450", value:TRUE);
 set_kb_item(name:"CVE-2007-6451", value:TRUE);
}
if ( rpm_exists(rpm:"libsmi-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-3389", value:TRUE);
 set_kb_item(name:"CVE-2007-3390", value:TRUE);
 set_kb_item(name:"CVE-2007-3391", value:TRUE);
 set_kb_item(name:"CVE-2007-3392", value:TRUE);
 set_kb_item(name:"CVE-2007-3393", value:TRUE);
 set_kb_item(name:"CVE-2007-6113", value:TRUE);
 set_kb_item(name:"CVE-2007-6114", value:TRUE);
 set_kb_item(name:"CVE-2007-6115", value:TRUE);
 set_kb_item(name:"CVE-2007-6117", value:TRUE);
 set_kb_item(name:"CVE-2007-6118", value:TRUE);
 set_kb_item(name:"CVE-2007-6120", value:TRUE);
 set_kb_item(name:"CVE-2007-6121", value:TRUE);
 set_kb_item(name:"CVE-2007-6450", value:TRUE);
 set_kb_item(name:"CVE-2007-6451", value:TRUE);
}

set_kb_item(name:"RHSA-2008-0059", value:TRUE);
