#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(30246);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2008-0412", "CVE-2008-0413", "CVE-2008-0415", "CVE-2008-0417", "CVE-2008-0418", "CVE-2008-0419", "CVE-2008-0591", "CVE-2008-0592", "CVE-2008-0593");

 name["english"] = "RHSA-2008-0104: seamonkey";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated seamonkey packages that fix several security issues are now
  available for Red Hat Enterprise Linux 2.1, 3, and 4.

  This update has been rated as having critical security impact by the Red
  Hat Security Response Team.

  SeaMonkey is an open source Web browser, advanced email and newsgroup
  client, IRC chat client, and HTML editor.

  Several flaws were found in the way SeaMonkey processed certain malformed
  web content. A webpage containing malicious content could cause SeaMonkey
  to crash, or potentially execute arbitrary code as the user running
  SeaMonkey. (CVE-2008-0412, CVE-2008-0413, CVE-2008-0415, CVE-2008-0419)

  Several flaws were found in the way SeaMonkey displayed malformed web
  content. A webpage containing specially-crafted content could trick a user
  into surrendering sensitive information. (CVE-2008-0591, CVE-2008-0593)

  A flaw was found in the way SeaMonkey stored password data. If a user
  saves login information for a malicious website, it could be possible
  to corrupt the password database, preventing the user from properly
  accessing saved password data. (CVE-2008-0417)

  A flaw was found in the way SeaMonkey handles certain chrome URLs. If a
  user has certain extensions installed, it could allow a malicious website
  to steal sensitive session data. Note: this flaw does not affect a default
  installation of SeaMonkey. (CVE-2008-0418)

  A flaw was found in the way SeaMonkey saves certain text files. If a
  website offers a file of type "plain/text", rather than "text/plain",
  SeaMonkey will not show future "text/plain" content to the user in the
  browser, forcing them to save those files locally to view the content.
  (CVE-2008-0592)

  Users of SeaMonkey are advised to upgrade to these updated packages, which
  contain backported patches to resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2008-0104.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the seamonkey packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"seamonkey-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-chat-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-devel-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-dom-inspector-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-js-debugger-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-mail-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-devel-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-devel-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-1.0.9-0.9.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-chat-1.0.9-0.9.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-devel-1.0.9-0.9.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-dom-inspector-1.0.9-0.9.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-js-debugger-1.0.9-0.9.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-mail-1.0.9-0.9.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-1.0.9-0.9.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-devel-1.0.9-0.9.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-1.0.9-0.9.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-devel-1.0.9-0.9.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-chat-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-devel-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-dom-inspector-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-js-debugger-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-mail-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-devel-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-devel-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-chat-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-devel-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-dom-inspector-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-js-debugger-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-mail-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-devel-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-devel-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-chat-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-devel-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-dom-inspector-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-js-debugger-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-mail-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-devel-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-devel-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-chat-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-devel-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-dom-inspector-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-js-debugger-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-mail-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-devel-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-devel-1.0.9-0.9.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-chat-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-devel-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-dom-inspector-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-js-debugger-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-mail-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-devel-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-devel-1.0.9-9.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"seamonkey-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2008-0412", value:TRUE);
 set_kb_item(name:"CVE-2008-0413", value:TRUE);
 set_kb_item(name:"CVE-2008-0415", value:TRUE);
 set_kb_item(name:"CVE-2008-0417", value:TRUE);
 set_kb_item(name:"CVE-2008-0418", value:TRUE);
 set_kb_item(name:"CVE-2008-0419", value:TRUE);
 set_kb_item(name:"CVE-2008-0591", value:TRUE);
 set_kb_item(name:"CVE-2008-0592", value:TRUE);
 set_kb_item(name:"CVE-2008-0593", value:TRUE);
}
if ( rpm_exists(rpm:"seamonkey-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2008-0412", value:TRUE);
 set_kb_item(name:"CVE-2008-0413", value:TRUE);
 set_kb_item(name:"CVE-2008-0415", value:TRUE);
 set_kb_item(name:"CVE-2008-0417", value:TRUE);
 set_kb_item(name:"CVE-2008-0418", value:TRUE);
 set_kb_item(name:"CVE-2008-0419", value:TRUE);
 set_kb_item(name:"CVE-2008-0591", value:TRUE);
 set_kb_item(name:"CVE-2008-0592", value:TRUE);
 set_kb_item(name:"CVE-2008-0593", value:TRUE);
}
if ( rpm_exists(rpm:"seamonkey-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2008-0412", value:TRUE);
 set_kb_item(name:"CVE-2008-0413", value:TRUE);
 set_kb_item(name:"CVE-2008-0415", value:TRUE);
 set_kb_item(name:"CVE-2008-0417", value:TRUE);
 set_kb_item(name:"CVE-2008-0418", value:TRUE);
 set_kb_item(name:"CVE-2008-0419", value:TRUE);
 set_kb_item(name:"CVE-2008-0591", value:TRUE);
 set_kb_item(name:"CVE-2008-0592", value:TRUE);
 set_kb_item(name:"CVE-2008-0593", value:TRUE);
}
if ( rpm_exists(rpm:"seamonkey-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2008-0412", value:TRUE);
 set_kb_item(name:"CVE-2008-0413", value:TRUE);
 set_kb_item(name:"CVE-2008-0415", value:TRUE);
 set_kb_item(name:"CVE-2008-0417", value:TRUE);
 set_kb_item(name:"CVE-2008-0418", value:TRUE);
 set_kb_item(name:"CVE-2008-0419", value:TRUE);
 set_kb_item(name:"CVE-2008-0591", value:TRUE);
 set_kb_item(name:"CVE-2008-0592", value:TRUE);
 set_kb_item(name:"CVE-2008-0593", value:TRUE);
}
if ( rpm_exists(rpm:"seamonkey-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2008-0412", value:TRUE);
 set_kb_item(name:"CVE-2008-0413", value:TRUE);
 set_kb_item(name:"CVE-2008-0415", value:TRUE);
 set_kb_item(name:"CVE-2008-0417", value:TRUE);
 set_kb_item(name:"CVE-2008-0418", value:TRUE);
 set_kb_item(name:"CVE-2008-0419", value:TRUE);
 set_kb_item(name:"CVE-2008-0591", value:TRUE);
 set_kb_item(name:"CVE-2008-0592", value:TRUE);
 set_kb_item(name:"CVE-2008-0593", value:TRUE);
}
if ( rpm_exists(rpm:"seamonkey-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2008-0412", value:TRUE);
 set_kb_item(name:"CVE-2008-0413", value:TRUE);
 set_kb_item(name:"CVE-2008-0415", value:TRUE);
 set_kb_item(name:"CVE-2008-0417", value:TRUE);
 set_kb_item(name:"CVE-2008-0418", value:TRUE);
 set_kb_item(name:"CVE-2008-0419", value:TRUE);
 set_kb_item(name:"CVE-2008-0591", value:TRUE);
 set_kb_item(name:"CVE-2008-0592", value:TRUE);
 set_kb_item(name:"CVE-2008-0593", value:TRUE);
}
if ( rpm_exists(rpm:"seamonkey-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2008-0412", value:TRUE);
 set_kb_item(name:"CVE-2008-0413", value:TRUE);
 set_kb_item(name:"CVE-2008-0415", value:TRUE);
 set_kb_item(name:"CVE-2008-0417", value:TRUE);
 set_kb_item(name:"CVE-2008-0418", value:TRUE);
 set_kb_item(name:"CVE-2008-0419", value:TRUE);
 set_kb_item(name:"CVE-2008-0591", value:TRUE);
 set_kb_item(name:"CVE-2008-0592", value:TRUE);
 set_kb_item(name:"CVE-2008-0593", value:TRUE);
}

set_kb_item(name:"RHSA-2008-0104", value:TRUE);
