#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31305);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2008-0554");

 name["english"] = "RHSA-2008-0131: netpbm";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated netpbm packages that fix a security issue are now available for Red
  Hat Enterprise Linux 2.1, 3, and 4.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The netpbm package contains a library of functions for editing and
  converting between various graphics file formats, including .pbm (portable
  bitmaps), .pgm (portable graymaps), .pnm (portable anymaps), .ppm (portable
  pixmaps) and others. The package includes no interactive tools and is
  primarily used by other programs (eg CGI scripts that manage web-site
  images).

  An input validation flaw was discovered in the GIF-to-PNM converter
  (giftopnm) shipped with the netpbm package. An attacker could create a
  carefully crafted GIF file which could cause giftopnm to crash or possibly
  execute arbitrary code as the user running giftopnm. (CVE-2008-0554)

  All users are advised to upgrade to these updated packages which contain a
  backported patch which resolves this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2008-0131.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the netpbm packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"netpbm-9.24-9.AS21.7", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-devel-9.24-9.AS21.7", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-progs-9.24-9.AS21.7", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-9.24-11.30.5", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-devel-9.24-11.30.5", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-progs-9.24-11.30.5", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-10.25-2.EL4.6.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-devel-10.25-2.EL4.6.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-progs-10.25-2.EL4.6.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-9.24-9.AS21.7", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-devel-9.24-9.AS21.7", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-progs-9.24-9.AS21.7", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-10.25-2.EL4.6.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-devel-10.25-2.EL4.6.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-progs-10.25-2.EL4.6.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-9.24-9.AS21.7", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-devel-9.24-9.AS21.7", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-progs-9.24-9.AS21.7", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-10.25-2.EL4.6.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-devel-10.25-2.EL4.6.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"netpbm-progs-10.25-2.EL4.6.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"netpbm-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2008-0554", value:TRUE);
}
if ( rpm_exists(rpm:"netpbm-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2008-0554", value:TRUE);
}
if ( rpm_exists(rpm:"netpbm-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2008-0554", value:TRUE);
}
if ( rpm_exists(rpm:"netpbm-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2008-0554", value:TRUE);
}
if ( rpm_exists(rpm:"netpbm-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2008-0554", value:TRUE);
}
if ( rpm_exists(rpm:"netpbm-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2008-0554", value:TRUE);
}
if ( rpm_exists(rpm:"netpbm-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2008-0554", value:TRUE);
}

set_kb_item(name:"RHSA-2008-0131", value:TRUE);
