#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31162);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5137", "CVE-2008-0553");

 name["english"] = "RHSA-2008-0136: tk";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated tk packages that fix a security issue are now available for Red Hat
  Enterprise Linux 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Tk is a graphical toolkit for the Tcl scripting language.

  An input validation flaw was discovered in Tk\'s GIF image handling. A
  code-size value read from a GIF image was not properly validated before
  being used, leading to a buffer overflow. A specially crafted GIF file
  could use this to cause a crash or, potentially, execute code with the
  privileges of the application using the Tk graphical toolkit.
  (CVE-2008-0553)

  A buffer overflow flaw was discovered in Tk\'s animated GIF image handling.
  An animated GIF containing an initial image smaller than subsequent images
  could cause a crash or, potentially, execute code with the privileges of
  the application using the Tk library. (CVE-2007-5137)

  All users are advised to upgrade to these updated packages which contain a
  backported patches to resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2008-0136.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tk packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"tk-8.4.13-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tk-devel-8.4.13-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"tk-8.4.13-5.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"tk-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-5137", value:TRUE);
 set_kb_item(name:"CVE-2008-0553", value:TRUE);
}
if ( rpm_exists(rpm:"tk-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-5137", value:TRUE);
 set_kb_item(name:"CVE-2008-0553", value:TRUE);
}

set_kb_item(name:"RHSA-2008-0136", value:TRUE);
