#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31185);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2008-0596", "CVE-2008-0597");

 name["english"] = "RHSA-2008-0153: cups";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated cups packages that fixes two security issues and a bug are now
  available for Red Hat Enterprise Linux 3.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  The Common UNIX Printing System (CUPS) provides a portable printing layer
  for UNIX(R) operating systems.

  A flaw was found in the way CUPS handled the addition and removal of remote
  shared printers via IPP. A remote attacker could send malicious UDP IPP
  packets causing the CUPS daemon to attempt to dereference already freed
  memory and crash. (CVE-2008-0597)

  A memory management flaw was found in the way CUPS handled the addition and
  removal of remote shared printers via IPP. When shared printer was
  removed, allocated memory was not properly freed, leading to a memory leak
  possibly causing CUPS daemon crash after exhausting available memory.
  (CVE-2008-0596)

  These issues were found during the investigation of CVE-2008-0882, which
  did not affect Red Hat Enterprise Linux 3.

  Note that the default configuration of CUPS on Red Hat Enterprise Linux
  3 allow requests of this type only from the local subnet.

  In addition, these updated cups packages fix a bug that occurred when using
  the CUPS polling daemon. Excessive debugging log information was saved to
  the error_log file regardless of the LogLevel setting, which filled up disk
  space rapidly.

  All CUPS users are advised to upgrade to these updated packages, which
  contain backported patches to resolve this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2008-0153.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cups packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"cups-1.1.17-13.3.51", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-devel-1.1.17-13.3.51", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-libs-1.1.17-13.3.51", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-1.1.17-13.3.51", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-devel-1.1.17-13.3.51", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-libs-1.1.17-13.3.51", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-1.1.17-13.3.51", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-devel-1.1.17-13.3.51", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cups-libs-1.1.17-13.3.51", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"cups-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2008-0596", value:TRUE);
 set_kb_item(name:"CVE-2008-0597", value:TRUE);
}
if ( rpm_exists(rpm:"cups-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2008-0596", value:TRUE);
 set_kb_item(name:"CVE-2008-0597", value:TRUE);
}
if ( rpm_exists(rpm:"cups-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2008-0596", value:TRUE);
 set_kb_item(name:"CVE-2008-0597", value:TRUE);
}

set_kb_item(name:"RHSA-2008-0153", value:TRUE);
