#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31307);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2008-0411");

 name["english"] = "RHSA-2008-0155: ghostscript";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated ghostscript packages that fix a security issue are now available
  for Red Hat Enterprise Linux 3, 4, and 5.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  Ghostscript is a program for displaying PostScript files, or printing them
  to non-PostScript printers.

  Chris Evans from the Google Security Team reported a stack-based buffer
  overflow flaw in Ghostscript\'s zseticcspace() function. An attacker could
  create a malicious PostScript file that would cause Ghostscript to execute
  arbitrary code when opened. (CVE-2008-0411)

  These updated packages also fix a bug, which prevented the pxlmono printer
  driver from producing valid output on Red Hat Enterprise Linux 4.

  All users of ghostscript are advised to upgrade to these updated packages,
  which contain a backported patch to resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2008-0155.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ghostscript packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"ghostscript-8.15.2-9.1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-devel-8.15.2-9.1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-gtk-8.15.2-9.1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-7.05-32.1.13", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-devel-7.05-32.1.13", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"hpijs-1.3-32.1.13", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-7.07-33.2.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-devel-7.07-33.2.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-gtk-7.07-33.2.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-8.15.2-9.1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-gtk-8.15.2-9.1.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-7.05-32.1.13", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-devel-7.05-32.1.13", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"hpijs-1.3-32.1.13", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-7.07-33.2.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-devel-7.07-33.2.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-gtk-7.07-33.2.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-7.05-32.1.13", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-devel-7.05-32.1.13", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"hpijs-1.3-32.1.13", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-7.07-33.2.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-devel-7.07-33.2.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ghostscript-gtk-7.07-33.2.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"ghostscript-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2008-0411", value:TRUE);
}
if ( rpm_exists(rpm:"ghostscript-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2008-0411", value:TRUE);
}
if ( rpm_exists(rpm:"ghostscript-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2008-0411", value:TRUE);
}
if ( rpm_exists(rpm:"ghostscript-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2008-0411", value:TRUE);
}
if ( rpm_exists(rpm:"ghostscript-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2008-0411", value:TRUE);
}
if ( rpm_exists(rpm:"ghostscript-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2008-0411", value:TRUE);
}
if ( rpm_exists(rpm:"ghostscript-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2008-0411", value:TRUE);
}
if ( rpm_exists(rpm:"ghostscript-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2008-0411", value:TRUE);
}

set_kb_item(name:"RHSA-2008-0155", value:TRUE);
