#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31389);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2008-0072");

 name["english"] = "RHSA-2008-0177: evolution";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated evolution packages that fix a format string bug are now available
  for Red Hat Enterprise Linux 4 and 5.

  This update has been rated as having critical security impact by the Red
  Hat Security Response Team.

  Evolution is the GNOME collection of personal information management (PIM)
  tools.

  A format string flaw was found in the way Evolution displayed encrypted
  mail content. If a user opened a carefully crafted mail message, arbitrary
  code could be executed as the user running Evolution. (CVE-2008-0072)

  All users of Evolution should upgrade to these updated packages, which
  contain a backported patch which resolves this issue.

  Red Hat would like to thank Ulf Härnhammar of Secunia Research for finding
  and reporting this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2008-0177.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the evolution packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"evolution-2.0.2-35.0.4.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution-devel-2.0.2-35.0.4.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution28-2.8.0-53.el4_6.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution28-devel-2.8.0-53.el4_6.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution-2.8.0-40.el5_1.1", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution-2.0.2-35.0.4.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution-devel-2.0.2-35.0.4.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution28-2.8.0-53.el4_6.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution28-devel-2.8.0-53.el4_6.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution-2.0.2-35.0.4.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution-devel-2.0.2-35.0.4.el4_6.1", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution28-2.8.0-53.el4_6.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"evolution28-devel-2.8.0-53.el4_6.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"evolution-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2008-0072", value:TRUE);
}
if ( rpm_exists(rpm:"evolution-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2008-0072", value:TRUE);
}
if ( rpm_exists(rpm:"evolution-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2008-0072", value:TRUE);
}
if ( rpm_exists(rpm:"evolution-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2008-0072", value:TRUE);
}

set_kb_item(name:"RHSA-2008-0177", value:TRUE);
