#
# This script was written by Vincent Renardias <vincent@strongholdnet.com>
#
# Licence : GPL v2
#

 desc["english"] = "
Synopsis :

The remote web server is affected by an information disclosure issue. 

Description :

Requesting the URI '/caucho-status' or '/server-status' gives
information about the currently running Resin java servlet container. 

Solution :

If you don't use this feature, set the content of the
'<caucho-status>' element to 'false' in the resin.conf file. 

Risk factor : 

Low / CVSS Base Score : 2.3
(AV:R/AC:L/Au:NR/C:P/I:N/A:N/B:N)";


if(description)
{
 script_id(11930);
 script_version ("$Revision: 1.5 $");
 name["english"] = "Resin status page accessible";
 
 script_name(english:name["english"]);
 
 script_description(english:desc["english"]);
 
 summary["english"] = "Requests Caucho status";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2003 StrongHoldNet");
 family["english"] = "Misc.";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_require_keys("www/apache");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

caucho_status[0] = "/caucho-status";
caucho_status[1] = "/server-status";

foreach page (caucho_status) {
  req = http_get(item:page, port:port);
  r = http_keepalive_send_recv(port:port, data:req);

  if(r && "<title>Status : Caucho Servlet Engine" >< r) {
    report = string(
      desc["english"],
      "\n\n",
      "Plugin output :\n",
      "\n",
      "The status page is available via the following URI :\n",
      "\n",
      "  ", page
    );
    security_note(port:port, data:report);
    exit(0);
  }
}

