#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(28333);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-5380", "CVE-2007-6077");
  script_bugtraq_id(26096, 26598);
  script_xref(name:"OSVDB", value:"39193");
  script_xref(name:"OSVDB", value:"40718");

  script_name(english:"Ruby on Rails Session Fixation Vulnerability");
  script_summary(english:"Tries to pass a session cookie via URL"); 
 
 desc = "
Synopsis :

The remote web server is affected by a session fixation vulnerability. 

Description :

The web server on the remote host appears to be a version of Ruby on
Rails that supports URL-based sessions.  An unauthenticated remote
attacker may be able to leverage this issue to obtain an authenticated
session. 

Note that Ruby on Rails version 1.2.4 was initially supposed to
address this issue, but its session fixation logic only works for the
first request, when CgiRequest is first instantiated. 

See also :

http://weblog.rubyonrails.org/2007/10/5/rails-1-2-4-maintenance-release
http://www.nessus.org/u?2f5b72e6
http://dev.rubyonrails.org/ticket/10048
http://www.nessus.org/u?1eeea9de

Solution :

Upgrade to Ruby on Rails version 1.2.6 or later and make sure
'config.action_controller.session_options[:cookie_only]' is set to
'true' in the 'config/environment.rb' file. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Web Servers");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl", "no404.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (get_kb_item("www/no404/" + port)) exit(0);


# Request a non-existent page.
foreach dir (cgi_dirs())
{
  url = string(dir, "/", unixtime(), "-", SCRIPT_NAME);

  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  if (res == NULL) exit(0);

  # Look for a session cookie.
  headers = res - strstr(res, '\r\n\r\n');
  if ("Set-Cookie: " >< headers)
  {
    pat = "Set-Cookie: +([^ =]+)=([a-h0-9]{32})[;|$]";
    matches = egrep(pattern:pat, string:res);
    if (matches)
    {
      foreach match (split(matches))
      {
        match = chomp(match);
        vals = eregmatch(pattern:pat, string:match);
        if (!isnull(vals))
        {
          cookie_name = vals[1];
          cookie_val = vals[2];

          # If either...
          if (
            # we're paranoid and the cookie name is not PHP's default or...
            (report_paranoia > 1 && cookie_name != "PHPSESSID") ||
            # it looks like one commonly used by RoR
            cookie_name =~ "_(sess|session)_id$"
          )
          {
            # Try to pass the cookie in as a parameter.
            req2 = http_get(
              item:string(url, "?", cookie_name, "=", cookie_val), 
              port:port
            );
            res2 = http_keepalive_send_recv(port:port, data:req2, bodyonly:FALSE);
            if (res2 == NULL) exit(0);

            # There's a problem if we get the same cookie back.
            if (string("Set-Cookie: ", cookie_name, "=", cookie_val) >< res2)
            {
              security_warning(port);
              exit(0);
            }
          }
        }
      }
    }
  }
}
