#
# (C) Tenable Network Security
#


if(description)
{
 script_id(10223);
 script_version ("$Revision: 1.25 $");
 name["english"] = "RPC portmapper";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

An ONC RPC portmapper is running on the remote host.

Description :

The RPC portmapper is running on this port.

The portmapper allows to get the port number of each RPC service
running on the remote host either by sending multiple lookup
requests or by sending a DUMP request.

Risk factor : 

None";

 script_description(english:desc["english"]);
 
 summary["english"] = "Gets the port of the remote rpc portmapper";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "RPC"; 
 script_family(english:family["english"]);
 
 exit(0);
}

#
# The script code starts here
#
include("misc_func.inc");
include("sunrpc_func.inc");

# the portmaper
RPC_PROG = 100000;

port = 0;
kb_registered = 0;

ports = make_list(111, 32771);
foreach p (ports)
{
 if(get_udp_port_state(p))
   port = get_rpc_port2(program:RPC_PROG, protocol:IPPROTO_UDP, portmap:p);
 else
   port = 0;
	  
 if(port)
 {
  if ( p != 111 ) set_kb_item(name:"rpc/portmap/different_port", value:p);

  if(kb_registered == 0)
  {
   set_kb_item(name:"rpc/portmap", value:p);
   kb_registered = 1;
  }
 register_service(port: p, proto: "portmapper", ipproto:"udp");
 security_note(p);
 }
}
