#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10228);
 script_version ("$Revision: 1.14 $");
 script_cve_id("CVE-1999-0626");
 
 name["english"] = "rusersd service";
 script_name(english:name["english"]);
 
 desc["english"] = "
The rusersd RPC service is running.  It provides an attacker interesting
information such as how often the system is being used, the names of
the users, and more.
	
It usually not a good idea to leave this service open.
Risk factor : Low";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks the presence of a RPC service";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison");
 family["english"] = "RPC"; 
 script_family(english:family["english"]);
 script_dependencie("rpc_portmap.nasl");
 script_require_keys("rpc/portmap");
 exit(0);
}

# deprecated by rusers_output.nasl
exit(0);