#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29868);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2008-0224");
  script_bugtraq_id(27152);
  script_xref(name:"OSVDB", value:"40101");

  script_name(english:"RunCMS Client-Ip Header SQL Injection Vulnerability");
  script_summary(english:"Tries to generate a SQL syntax error");

  desc = "
Synopsis :

The remote web server contains a PHP application that is prone to a
SQL injection attack. 

Description :

The version of RunCMS installed on the remote host fails to sanitize
user-supplied input to the 'Client-Ip' request header before using it
in a database query in the 'newbb_plus' module.  Regardless of PHP's
'magic_quotes_gpc' setting, an attacker may be able to exploit this
issue to manipulate database queries, leading to disclosure of
sensitive information, modification of data, or attacks against the
underlying database. 

Note that the module is not enabled by default. 

See also :

http://www.milw0rm.com/exploits/4845

Solution :

Unknown at this time. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("runcms_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/runcms"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Try to exploit the issue to generate a SQL syntax error.
  exploit = string("1.2.3.4' ", SCRIPT_NAME);
  exploit = urlencode(str:exploit);

  req = http_get(
    item:string(dir, "/modules/newbb_plus/"), 
    port:port
  );
  req = str_replace(
    string:req,
    find:"User-Agent:",
    replace:string(
      "Client-Ip: ", exploit, "\r\n",
      "User-Agent:"
    )
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we see a syntax error.
  if (
    '_whosonline where timestamp' >< res &&
    string(" OR user_ip='", exploit) >< res
  )
  {
    security_warning(port);
    exit(0);
  }
}
