#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25217);
  script_version("$Revision: 1.7 $");

  script_cve_id("CVE-2007-2444", "CVE-2007-2446", "CVE-2007-2447");
  script_bugtraq_id(23972, 23973, 23974, 24195, 24196, 24197, 24198);
  script_xref(name:"OSVDB", value:"34700");
  script_xref(name:"OSVDB", value:"34732");

  script_name(english:"Samba < 3.0.25 Multiple Vulnerabilities");
  script_summary(english:"Checks version of Samba");

  desc = "
Synopsis :

The remote Samba server is affected by multiple vulnerabilities. 

Description :

According to its banner, the version of the Samba server installed on
the remote host is affected by multiple buffer overflow and remote
command injection vulnerabilities, which can be exploited remotely, as
well as a local privilege escalation bug. 

See also :

http://www.samba.org/samba/security/CVE-2007-2444.html
http://www.samba.org/samba/security/CVE-2007-2446.html
http://www.samba.org/samba/security/CVE-2007-2447.html

Solution :

Upgrade to Samba version 3.0.25 or later. 

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Misc.");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("smb_nativelanman.nasl");
  script_require_keys("SMB/NativeLanManager");

  exit(0);
}


include("global_settings.inc");


# nb: this check is unreliable since the patches released by samba.org
#     don't update the version.
if (report_paranoia < 2) exit(0);


lanman = get_kb_item("SMB/NativeLanManager");
if("Samba" >< lanman)
{
  if (ereg(pattern:"Samba 3\.0\.([0-9]|1[0-9]|2[0-4]|25(pre|rc))[^0-9]*$", string:lanman, icase:TRUE))
    security_hole(get_kb_item("SMB/transport"));
}
