#
# (C) Tenable Network Security
#

 desc_normal["english"] = "
Synopsis :

An SMB server is running on the remote host.

Description :

The remote host is running a SAMBA server, a CIFS/SMB
server for Unix.

See also :

http://www.samba.org

Risk factor :

None";


 desc_hide["english"] = "
Synopsis :

An SMB server is running on the remote host.

Description :

The remote host tries to hide its SMB server type by changing
the MAC address and the LAN manager name.
However by sending several valid and invalid RPC requests it was
possible to fingerprint the remote SMB server as SAMBA.

See also :

http://www.samba.org

Risk factor :

None";


if(description)
{
 script_id(25240);
 script_version ("$Revision: 1.3 $");

 name["english"] = "SAMBA server detection";
 
 script_name(english:name["english"]);
 
 script_description(english:desc_normal["english"]);
 
 summary["english"] = "Attempts to detect a SAMBA server";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "Service detection";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl");
 script_require_keys("SMB/name", "SMB/transport");
 script_require_ports(139, 445);
 exit(0);
}

include ("smb_func.inc");

function _RpcSpoolerInit ()
{
 local_var fid, data, type, error;

 fid = bind_pipe (pipe:"\spoolss", uuid:"12345678-1234-abcd-ef00-0123456789ab", vers:1);
 if (isnull(fid))
   return FALSE;

 data = raw_word(w:0);

 data = dce_rpc_pipe_request (fid:fid, code:0x3f, data:data);
 smb_close (fid:fid);

 if (!data)
   return FALSE;

 if (strlen (data) < 28)
   return FALSE;
   
 type = get_byte (blob:data, pos:2);

 # Fault -> maybe samba
 if (type != 3)
   return FALSE;

 error = get_dword (blob:data, pos:24);
 if (error == 0x1c010002) # nca_op_rng_error
   return TRUE;

 return FALSE;
}


function _LsaDelete ()
{
 local_var fid, data, type, error;

 fid = bind_pipe (pipe:"\lsarpc", uuid:"12345778-1234-abcd-ef00-0123456789ab", vers:0);
 if (isnull(fid))
   return FALSE;

 data = NULL;

 data = dce_rpc_pipe_request (fid:fid, code:0x01, data:data);
 smb_close (fid:fid);

 if (!data)
   return FALSE;

 if (strlen (data) < 28)
   return FALSE;
   
 type = get_byte (blob:data, pos:2);

 # Fault -> maybe samba
 if (type != 3)
   return FALSE;

 error = get_dword (blob:data, pos:24);
 if (error == 0x1c010002) # nca_op_rng_error
   return TRUE;

 return FALSE;
}


function register_samba()
{
 local_var kb;

 kb = get_kb_item("SMB/samba");

 if (!kb)
 {
  set_kb_item(name:"SMB/samba", value:TRUE);  
  security_note(port:port, data:desc_hide["english"]);
 }
 else
   security_note(port:port, data:desc_normal["english"]);
}


name	= kb_smb_name();
port	= kb_smb_transport();

if ( ! get_port_state(port) ) exit(0);
soc = open_sock_tcp(port);
if ( ! soc ) exit(0);

session_init(socket:soc, hostname:name);
r = NetUseAdd(share:"IPC$");
if ( r != 1 ) exit(0);

# 1) test the only samba specific RPC service (unixinfo)
fid = bind_pipe (pipe:"\unixinfo", uuid:"9c54e310-a955-4885-bd31-78787147dfa6", vers:0);
if (!isnull (fid))
{
 smb_close(fid:fid);
 register_samba();
}
else
{
 # 2) test an undefined RPC function in samba (SPOOLSS)
 ret = _RpcSpoolerInit();
 if (ret)
   register_samba();
 else
 {
  # 3) test an undefined RPC function in samba (LSARPC)
  ret = _LsaDelete();
  if (ret)
    register_samba();
 }
}

NetUseDel();
