#
# (C) Tenable Network Security, Inc.
#

if(description)
{
 script_id(24684);
 script_bugtraq_id(17314);
 script_cve_id("CVE-2006-1059");
 script_xref(name:"OSVDB", value:"24263");
 script_version ("$Revision: 1.3 $");
 name["english"] = "Samba Machine Trust Account Local Information Disclosure Vulnerability";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote Samba server is vulnerable to a local information
disclosure flaw. 

Description :

According to its version number, the remote Samba server is affected
by a flaw that may allows a local attacker to get access to the
passwords sent to the winbindd daemon if the debug level has been set
to 5 or higher. 

See also :

http://www.securityfocus.com/archive/1/archive/1/429370/100/0/threaded
http://us1.samba.org/samba/security/CVE-2006-1059.html

Solution : 

Upgrade to Samba 3.0.22 or set the debug level to a value lower
than 5.

Risk factor :

Low / CVSS Base Score : 1.2
(CVSS2#AV:L/AC:H/Au:N/C:P/I:N/A:N)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Checks the version of Samba";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
  
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 
 family["english"] = "Misc.";
 script_family(english:family["english"]);
 script_dependencie("smb_nativelanman.nasl");
 script_require_keys("SMB/NativeLanManager");
 exit(0);
}

#
# The script code starts here
#
include("global_settings.inc");

if ( report_paranoia < 2 ) exit(0);

lanman = get_kb_item("SMB/NativeLanManager");
if("Samba" >< lanman)
{
 if(ereg(pattern:"Samba 3\.0\.21($|[a-c]$)", string:lanman))
   security_note(get_kb_item("SMB/transport"));
}
