#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#
# Script audit and contributions from Carmichael Security <http://www.carmichaelsecurity.com>
#      Erik Anderson <eanders@carmichaelsecurity.com>
#      Added BugtraqID
#
# Refs: o http://lists.samba.org/pipermail/samba-technical/2002-June/037400.html
#       o FreeBSD-SN-02:05
#
# Only Samba 2.2.4 is affected by this.
#

if(description)
{
 script_id(11113);
 script_cve_id("CVE-2002-2196");
 script_bugtraq_id(5587);
 script_version ("$Revision: 1.10 $");
 if ( defined_func("script_xref") ) script_xref(name:"SuSE", value:"SUSE-SA:2002:045");

 name["english"] = "Samba Buffer Overflow";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote Samba server may be affected by a buffer overflow issue. 

Description :

The remote Samba server, according to its version number, is
vulnerable to a possible buffer overflow because it fails to properly
terminate the 'enum_csc_policy' struct. 

See also : 

http://lists.samba.org/archive/samba-technical/2002-June/022075.html
http://www.samba.org/samba/history/samba-2.2.5.html

Solution : 

Upgrade to Samba 2.2.5 or later.

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
 script_description(english:desc["english"]);
 
 summary["english"] = "checks samba version";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison");
 family["english"] = "Gain root remotely";
 script_family(english:family["english"]);
 script_dependencie("smb_nativelanman.nasl");
 script_require_ports(139);
 script_require_keys("SMB/NativeLanManager");
 exit(0);
}

#
# The script code starts here
#

lanman = get_kb_item("SMB/NativeLanManager");
if("Samba" >< lanman)
{
 if(ereg(pattern:"Samba 2\.2\.4[^0-9]*$",
 	 string:lanman))security_hole(139);
}
